import cv2
from datetime import datetime
import time
import numpy as np
from turbojpeg import TurboJPEG
import os
jpeg = TurboJPEG("/root/v2x_mas_emb/lib/libturbojpeg.so")  # 使用绝对路径
def fun(out_file_name):
    width = 1920
    height = 1080
    with open("1.rgb", "rb") as in_file:
        input_buff = in_file.read()
    buf_data = np.frombuffer(input_buff, dtype=np.uint8)
    raw_img = buf_data.reshape((height, width, 3)).copy()
    t_start = time.perf_counter()
    loop = 1
    x = 40
    y = 290

    for _ in range(loop):
        # 添加时间OSD
        cv2.putText(raw_img, datetime.now().strftime("%Y-%m-%d %H:%M:%S"), (x, y), cv2.FONT_HERSHEY_SIMPLEX, 1.2, (0, 0, 0), 3)

    t_end = time.perf_counter()
    print(f"[{out_file_name}][{loop} times ]cost=====================: {(t_end - t_start)*1000*1000/loop:.0f} us")
    raw_img = cv2.cvtColor(raw_img, cv2.COLOR_BGR2RGB)
    encoded_img = jpeg.encode(raw_img, quality=85)
    with open(out_file_name, "wb") as out_file:
        out_file.write(encoded_img)

def fun1(in_file_name):
    width = 1920
    height = 1080
    with open(in_file_name, "rb") as in_file:
        input_buff = in_file.read()
    input_buff = cv2.imdecode(np.frombuffer(input_buff, np.uint8), cv2.IMREAD_COLOR)
    buf_data = np.frombuffer(input_buff, dtype=np.uint8)
    raw_img = buf_data.reshape((height, width, 3)).copy()
    t_start = time.perf_counter()
    loop = 1000

    for _ in range(loop):
        osd_x = 40
        osd_y = 190
        time_str = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        for char in time_str:
            text_size, _ = cv2.getTextSize(char, cv2.FONT_HERSHEY_SIMPLEX, 1.2, 3)
            osd_region = raw_img[osd_y - text_size[1]:osd_y, osd_x:osd_x + text_size[0]]
            average_gray = cv2.mean(cv2.cvtColor(osd_region, cv2.COLOR_BGR2GRAY))[0]
            color = (250, 250, 250)
            if average_gray > 160:
                color = (5, 5, 5)
            cv2.putText(raw_img, char, (osd_x, osd_y), cv2.FONT_HERSHEY_SIMPLEX, 1.2, color, 3)
            osd_x += cv2.getTextSize(char, cv2.FONT_HERSHEY_SIMPLEX, 1.2, 3)[0][0] - 4

    t_end = time.perf_counter()
    print(f"[{in_file_name}][{loop} times ]cost=====================: {(t_end - t_start)*1000*1000/loop:.0f} us")
    raw_img = cv2.cvtColor(raw_img, cv2.COLOR_BGR2RGB)
    encoded_img = jpeg.encode(raw_img, quality=85)
    output_file_name = "out_" + os.path.basename(in_file_name)
    with open(output_file_name, "wb") as out_file:
        out_file.write(encoded_img)


if __name__ == "__main__":
    for filename in os.listdir("images"):
        if filename.endswith(".jpg"):
            fun1(os.path.join("images", filename))  # 调用fun函数
