#!/bin/bash

# 停止现有的NTP服务
sudo timedatectl set-ntp false

# 备份原始配置文件
sudo cp /etc/systemd/timesyncd.conf /etc/systemd/timesyncd.conf.bak

# 配置新的NTP服务器
sudo tee /etc/systemd/timesyncd.conf > /dev/null <<EOF
[Time]
NTP=ntp.aliyun.com
FallbackNTP=ntp.tencent.com
EOF

# 启用NTP服务
sudo timedatectl set-ntp true

# 重启时间同步服务
sudo systemctl restart systemd-timesyncd

# 等待服务稳定
sleep 2

# 显示服务状态
echo -e "\n### NTP服务状态 ###"
timedatectl timesync-status --no-pager

# 显示当前时间配置
echo -e "\n### 当前时间配置 ###"
timedatectl
